float4x4 mWorldViewProj;
float4x4 mWorldViewInv;
float gTime;

struct VS_OUTPUT
{
    float4 Position		: POSITION;   // vertex position 
    float2 uv			: TEXCOORD0;
    float3 Normal		: TEXCOORD1;
    float3 SecPos		: TEXCOORD2;
};

#define PI 3.14159265354

float3x3 buildRotationMatrix(in float x, in float y, in float z) {
	float3x3 mat;
	
	mat[0][0] = cos(y);
	mat[0][1] = 0.0f;
	mat[0][2] = -sin(y);
	
	mat[1][0] = sin(x)*sin(y);
	mat[1][1] = cos(x);
	mat[1][2] = sin(x)*cos(y);
	
	mat[2][0] = cos(x)*sin(y);
	mat[2][1] = -sin(x);
	mat[2][2] = cos(x)*cos(y);
	
	
	//mat = transpose(mat);
	
	return mat;
}

VS_OUTPUT main( in float4 pos : POSITION,
				in float2 uv : TEXCOORD0,
				in float3 normal : NORMAL)
{
	VS_OUTPUT Output;
	
	float time = gTime*0.003f;
	/*
	float amp = 0.0f;
	
	pos.x += normal.x*amp;
	pos.y += normal.y*amp;
	pos.z += normal.z*amp;
	*/
	float rx = sin(pos.x/50*(PI*2.0f)*1.0f+time*0.7f)+time*0.5f;
	float3x3 mat = buildRotationMatrix(rx, 0.0f, 0.0f);
	pos.xyz = mul(pos.xyz, mat);
	normal = mul(normal, mat);
	
    Output.Position = mul(pos, mWorldViewProj);
    Output.Normal = mul(mWorldViewInv, normal);
    Output.uv = uv;
    Output.SecPos = Output.Position;
    
    
    return Output;
}